<?php

class robodn_DonationManager_Helper_Currency
{
	protected static $_currencies = array(
		'RUR', 'WMR');

	public static function getAbbreviations()
	{
		return self::$_currencies;
	}

	public static function getCurrencies()
	{
		$ret = array();
		foreach (self::$_currencies as $cur)
		{
			$ret[$cur] = new XenForo_Phrase('robodn_currency_' . $cur);
		}

		return $ret;
	}

	public static function getAmountForTemplate($amount, $currency)
	{
		if (!in_array($currency, self::$_currencies))
		{
			$currency = 'RUR';
		}

		return new XenForo_Phrase('robodn_amount_' . $currency, array('amount' => $amount));
	}

	public static function helperAmountText($amount, $currency = null)
	{
		if ($currency === null)
		{
			$currency = XenForo_Application::get('options')->donationCurrency;
		}

		return self::getAmountForTemplate(XenForo_Locale::numberFormat($amount, 2), $currency);
	}
}