<?php

class robodn_DonationManager_Installer extends robodn_DonationManager_Common_Installer
{
	protected $_tables = array(
		'robodn_donation' => "
			donation_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
			transaction_id TEXT NOT NULL,
			user_id TEXT NOT NULL,
			goal_id INT UNSIGNED NOT NULL DEFAULT '0',
			username VARCHAR(50) NOT NULL,
			amount DECIMAL(10,2) UNSIGNED NOT NULL,
			note VARCHAR(150) NOT NULL,
			donation_date TEXT NOT NULL,
			anonymous TEXT NOT NULL,
			PRIMARY KEY (donation_id)
		",

		'robodn_donor' => "
			user_id INT UNSIGNED NOT NULL,
			anonymous TINYINT UNSIGNED NOT NULL DEFAULT '0',
			amount DECIMAL(10,2) UNSIGNED NOT NULL,
			last_donation_date INT UNSIGNED DEFAULT 0 NOT NULL
		",

		'robodn_donation_log' => "
			donation_log_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
			donation_id INT UNSIGNED NOT NULL,
			processor VARCHAR(25) NOT NULL,
			transaction_id VARCHAR(50) NOT NULL,
			transaction_type ENUM('payment','cancel','info','error') NOT NULL,
			message VARCHAR(255) NOT NULL,
			transaction_details MEDIUMBLOB NOT NULL,
			log_date INT UNSIGNED NOT NULL,
			PRIMARY KEY (donation_log_id)
		",

		'robodn_goal' => "
			goal_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
			summm TEXT NOT NULL,
			title VARCHAR(255) NOT NULL,
			description TEXT NOT NULL,
			donated TEXT NOT NULL,
			goal TEXT NOT NULL,
			goal_reached ENUM('', 'restart', 'archive') NOT NULL DEFAULT '',
			start_date INT UNSIGNED NOT NULL,
			end_date INT UNSIGNED NOT NULL,
			recurring TINYINT(3) unsigned NOT NULL DEFAULT '0',
			archived TINYINT(3) unsigned NOT NULL DEFAULT '0',
			feature TINYINT UNSIGNED NOT NULL,
			display_order INT UNSIGNED NOT NULL,
			PRIMARY KEY (goal_id)
		",

		'robodn_goal_log' => "
			goal_log_id INT(10) unsigned NOT NULL AUTO_INCREMENT,
			goal_id INT(10) unsigned NOT NULL,
			goal DECIMAL(10,2) unsigned NOT NULL,
			donated DECIMAL(10,2) unsigned NOT NULL,
			start_date INT(10) unsigned NOT NULL,
			end_date INT(10) unsigned NOT NULL,
			PRIMARY KEY (goal_log_id)
		",

		'robodn_donation_transaction' => "
			transaction_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
			token VARCHAR(32) NOT NULL,
			user_id INT UNSIGNED NOT NULL,
			goal_id INT UNSIGNED NOT NULL DEFAULT 0,
			amount DECIMAL(10,2) UNSIGNED NOT NULL,
			note VARCHAR(150) NOT NULL,
			anonymous TINYINT(3) UNSIGNED NOT NULL,
			transaction_state ENUM('waiting','commited','reversed') NOT NULL DEFAULT 'waiting',
			PRIMARY KEY (transaction_id)
		",
	);

	public static function install($existingAddon, $addonData)
	{
		$i = new self($existingAddon, $addonData);
		$i->run();
	}

	public static function uninstall($existingAddon)
	{
		$i = new self($existingAddon);
		$i->run(true);
	}

	public function run($uninstall = false)
	{
		if ( ! $uninstall)
		{
			// This needs to be run, hacking it in this way so it does no matter what
			$this->_upgradeVersion48();
		}

		return parent::run();
	}

	protected function _install()
	{
		parent::_install();

		$this->_db->query("REPLACE INTO xf_option_group_relation (option_id, group_id, display_order) VALUES ('robokassaPrimaryAccount', 'robodnDonations', 110)");
	}

	protected function _upgradeVersion10()
	{
		// I stupidly left debug info in the goal log causing all months to enter one month into the future, this takes them back a month
		$this->_db->query('
			UPDATE robodn_donation_goal
			SET goal_date = goal_date - 2629743
		');

		$donations = $this->_db->fetchAll('
			SELECT *
			FROM robodn_user_donation AS donation
				INNER JOIN robodn_user_donate AS donate ON (donate.user_id = donation.user_id AND donate.anonymous = donation.anonymous)
		');
		$latestDates = array();
		foreach ($donations as $donation)
		{
			if (!isset($latestDates[$donation['user_id']][$donation['anonymous']]))
			{
				$latestDates[$donation['user_id']][$donation['anonymous']] = 0;
			}
			$ref = &$latestDates[$donation['user_id']][$donation['anonymous']];
			$ref = max($ref, $donation['donation_date']);
		}

		foreach ($latestDates as $userId => $values)
		{
			foreach ($values as $anonymous => $date)
			{
				$this->_db->update(
					'robodn_user_donate',
					array('last_donation_date' => $date),
					"user_id = $userId AND anonymous = $anonymous"
				);
			}
		}

		try
		{
			$this->_db->query('ALTER TABLE robodn_user_donate ADD COLUMN last_donation_date INT UNSIGNED DEFAULT 0 NOT NULL');
		}
		catch (Exception $e) {}
	}

	protected function _upgradeVersion11()
	{
		try
		{
			$this->_db->query('ALTER TABLE robodn_donation_goal CHANGE COLUMN description MEDIUMTEXT NOT NULL');
		}
		catch (Exception $e) {}
	}

	protected function _upgradeVersion13()
	{
		$this->_db->delete('robodn_user_donate', 'amount = 0');
	}

	protected function _upgradeVersion15()
	{
		$this->_db->query('RENAME TABLE robodn_user_donation TO robodn_donation');
		$this->_db->query('RENAME TABLE robodn_user_donation_log TO robodn_donation_log');
		$this->_db->query('RENAME TABLE robodn_user_donate TO robodn_donor');

		$this->_db->query("ALTER TABLE robodn_donation CHANGE user_donation_id donation_id INT UNSIGNED NOT NULL AUTO_INCREMENT");
		$this->_db->query("ALTER TABLE robodn_donation_log CHANGE user_donation_id donation_id INT UNSIGNED NOT NULL");
		$this->_db->query("ALTER TABLE robodn_donation_log CHANGE user_donation_log_id donation_log_id INT UNSIGNED NOT NULL AUTO_INCREMENT");
	}

	protected function _upgradeVersion18()
	{
		try
		{
			$this->_db->query('ALTER TABLE robodn_donor ADD COLUMN last_donation_date INT UNSIGNED DEFAULT 0 NOT NULL');
		}
		catch (Exception $e) {}
	}

	protected function _upgradeVersion22()
	{
		// This will be run once and for all!
		try
		{
			$this->_db->query('ALTER TABLE robodn_donation_goal CHANGE description MEDIUMTEXT NOT NULL');
		}
		catch (Exception $e) {}

		if ($userIds = $this->_db->fetchCol('SELECT user_id FROM robodn_donation'))
		{
			robodn_DonationManager_Common_Helper::promoteUsers($userIds);
		}
	}

	protected function _upgradeVersion24()
	{
		try
		{
			$this->_db->query("
				ALTER TABLE robodn_donation
					ADD COLUMN transaction_id INT UNSIGNED NOT NULL AFTER donation_id
			");
		}
		catch (Exception $e) {}

		$options = XenForo_Application::getOptions();
		$goalId = 0;
		if ($options->donationGoalAmount)
		{
			$dw = XenForo_DataWriter::create('robodn_DonationManager_DataWriter_Goal');
			$dw->bulkSet(array(
				'title' => $options->donationGoalTitle ? $options->donationGoalTitle : '-',
				'description' => $options->donationGoalDescription,
				'goal' => $options->donationGoalAmount,
				'start_date' => mktime(0, 0, 0, date('n'), 1),
				'end_date' => mktime(0, 0, 0, date('n') + 1, 0),
				'recurring' => 1,
				'feature' => 1,
			));

			$dw->save();
			$goalId = $dw->get('goal_id');
		}

		$logs = $this->_db->fetchAll('
			SELECT *
			FROM robodn_donation_goal
		');

		foreach ($logs AS $log)
		{
			$this->_db->insert(
				'robodn_goal_log',
				array('goal_id' => $goalId, 'goal' => $log['goal'], 'donated' => $log['raised'], 'start_date' => $log['goal_date'], 'end_date' => $log['goal_date'] + 2592000)
			);
		}
	}

	protected function _upgradeVersion47()
	{
		// Try get robokassa back in options...
		$this->_db->query("REPLACE INTO xf_option_group_relation (option_id, group_id, display_order) VALUES ('robokassaPrimaryAccount', 'robodnDonations', 110)");

		// Doesn't seem to have run :/
		$this->_upgradeVersion24();

		$goalId = $this->_db->fetchOne('SELECT MIN(goal_id) FROM robodn_goal');
		if ($goalId)
		{
			$donations = $this->getModelFromCache('robodn_DonationManager_Model_Donation')->getDonations(array('goal' => 0));
			foreach ($donations AS $donation)
			{
				$dw = XenForo_DataWriter::create('robodn_DonationManager_DataWriter_Donation');
				$dw->setExistingData($donation);
				$dw->set('goal_id', $goalId);
				$dw->save();
			}
		}
	}

	protected function _upgradeVersion48()
	{
		// For some reason people are missing this column
		try
		{
			$this->_db->query("
				ALTER TABLE robodn_donation
					ADD COLUMN transaction_id INT UNSIGNED NOT NULL AFTER donation_id
			");
		}
		catch (Exception $e) {}
	}

	protected function _uninstall()
	{
		parent::_uninstall();

		$this->_db->delete('xf_option_group_relation', "option_id = 'robokassaPrimaryAccount' AND group_id = 'robodnDonations'");
	}
}