<?php

class robodn_DonationManager_Listener extends robodn_DonationManager_Common_Listener
{
	protected static $_criteriaUserCache = array();

	protected $_template;

	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$l = new self();
		$l->_template = $template;
		$l->callTemplateMethod($hookName, $contents);
	}

	public static function fileHealthCheck(XenForo_ControllerAdmin_Abstract $controller, array &$hashes)
	{
		$hashes += robodn_DonationManager_FileSums::getHashes();
	}

	public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
	{
		XenForo_Template_Helper_Core::$helperCallbacks['amount'] = array('robodn_DonationManager_Helper_Currency', 'helperAmountText');
		XenForo_Template_Helper_Core::$helperCallbacks['goaltimeleft'] = array('robodn_DonationManager_Helper_Goal', 'helperGoalTimeLeft');
		XenForo_Template_Helper_Core::$helperCallbacks['progressrgb'] = array('robodn_DonationManager_Helper_Color', 'helperProgressBarRGB');

		if ($dependencies instanceof XenForo_Dependencies_Public)
		{
			$dependencies->notices['showDonationsOffNotice'] = 'robodn_notice_donations_off';
		}
	}

	public static function loadClass($class, array &$extend)
	{
		if ($class == 'XenForo_DataWriter_User')
		{
			XenForo_DataWriter_User::$usernameChangeUpdates = array_merge(XenForo_DataWriter_User::$usernameChangeUpdates, array(
				'permanent' => array(
					'donation' => array('robodn_donation', 'username', 'user_id')
				)
			));
		}
	}

	public static function navigationTabs(array &$extraTabs, $selectedTabId)
	{
		$visitor = XenForo_Visitor::getInstance();

		if ($visitor->hasPermission('donation', 'viewNav'))
		{
			$extraTabs['donations'] = array(
				'title' => new XenForo_Phrase('donate'),
				'href' => XenForo_Link::buildPublicLink('donate'),
				'position' => 'middle',
			);
		}
	}

	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'forum_list')
		{
			$template->preloadTemplate('robodn_donation_sidebar');
		}
	}

	public static function visitorSetup(XenForo_Visitor &$visitor)
	{
		$options = XenForo_Application::get('options');
		if ($options->donationGoalAmount)
		{
			$tokens = array(
				'{name}' => $visitor['username'] !== '' ? $visitor['username'] : new XenForo_Phrase('guest')
			);

			$options->donationGoalTitle = str_replace(array_keys($tokens), $tokens, $options->donationGoalTitle);
			$options->donationGoalDescription = str_replace(array_keys($tokens), $tokens, $options->donationGoalDescription);

			XenForo_Application::set('options', $options);
		}
	}

	public static function criteriaUser($rule, $data, $user, &$returnValue)
	{
		$l = new self();
		$l->checkCriteria($rule, $data, $user, $returnValue);
	}

	public function checkCriteria($rule, $data, $user, &$returnValue)
	{
		$method = '_rule' . ucfirst(Zend_Filter::filterStatic($rule, 'Word_UnderscoreToCamelCase'));

		if ( ! method_exists($this, $method))
		{
			return;
		}

		if ( ! empty(self::$_criteriaUserCache[$user['user_id']]))
		{
			$user = array_merge($user, self::$_criteriaUserCache[$user['user_id']]);
		}
		else
		{
			$user = $this->_getExtraUserData($user);
			self::$_criteriaUserCache[$user['user_id']] = $user;
		}

		$returnValue = $this->{$method}($data, $user);
	}

	protected function _getExtraUserData(array $user)
	{
		return $this->_getDonorModel()->getExtraDonationDataForUser($user);
	}

	protected function _ruleDonatedMinimum($data, $user)
	{
		if ($user['donated'] < $data['donated'])
		{
			return false;
		}

		return true;
	}

	protected function _ruleDonatedMaximum($data, $user)
	{
		if ($user['donated'] > $data['donated'])
		{
			return false;
		}

		return true;
	}

	protected function _ruleMinimumDonationDays($data, $user)
	{
		if ( ! isset($user['last_donated_date']))
		{
			return false;
		}

		$daysSinceLastDonation = floor((XenForo_Application::$time - $user['last_donated_date']) / 86400);
		if ($daysSinceLastDonation > $data['days'])
		{
			return false;
		}

		return true;
	}

	protected function _ruleMaximumDonationDays($data, $user)
	{
		if ( ! isset($user['last_donated_date']))
		{
			return false;
		}

		$daysSinceLastDonation = floor((XenForo_Application::$time - $user['last_donated_date']) / 86400);
		if ($daysSinceLastDonation < $data['days'])
		{
			return false;
		}

		return true;
	}

	protected function _forumListSidebar(&$contents)
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewIndex'))
		{
			return;
		}

		$options = XenForo_Application::get('options');
		$donationModel = $this->_getDonationModel();
		$donorModel = $this->_getDonorModel();
		$goalModel = $this->_getGoalModel();
		$visitor = XenForo_Visitor::getInstance();
		$viewParams = array();

		if ($options->donationSidebar['goal'])
		{
			$goals = $goalModel->getGoals(array(
				'feature' => 1,
				'archived' => 0,
				'hideFuture' => 1
			));

			$viewParams += array(
				'goals' => $goalModel->prepareGoals($goals),

				'canDonate' => XenForo_Visitor::getInstance()->hasPermission('donation', 'donate'),
			);
		}

		if ($options->donationSidebar['topDonations'] && $visitor->hasPermission('donation', 'viewDonations'))
		{
			$viewParams['topDonations'] = $donationModel->getDonations(array(), array(
				'limit' => $options->sidebarTopDonationsAmount,
				'order' => 'donation_date',
				'direction' => 'asc',
				'join' => robodn_DonationManager_Model_Donation::FETCH_USER,
			));
		}

		if ($options->donationSidebar['topDonors'] && $visitor->hasPermission('donation', 'viewDonors'))
		{
			$viewParams['topDonors'] = $donorModel->prepareDonors($donorModel->getDonors(array(), array(
				'limit' => $options->sidebarTopDonorsAmount,
				'order' => 'donation_date',
				'direction' => 'asc',
				'join' => robodn_DonationManager_Model_Donation::FETCH_USER,
			)));
		}

		if ($viewParams)
		{
			$newContent = $this->_template->create('robodn_donation_sidebar', array_merge($viewParams, $this->_template->getParams()));

			if ($options->donationSidebarPosition == 'top')
			{
				$contents = $newContent . $contents;
			}
			else
			{
				$needles = array(
					'staff' => '<!-- end block: sidebar_online_staff -->',
					'members' => '<!-- end block: sidebar_online_users -->',
					'stats' => '<!-- end block: forum_stats -->'
				);

				$needle = $needles[$options->donationSidebarPosition];
				$pos = strpos($contents, $needle);
				if ($pos !== false)
				{
					$pos += strlen($needle);
					$contents = substr($contents, 0, $pos) . $newContent . substr($contents, $pos);
				}
			}
		}
	}

	protected function _userCriteriaExtra(&$contents)
	{
		$contents .= $this->_template->create('robodn_donation_user_criteria', $this->_template->getParams());
	}

	protected function _adminIconsApplication(&$contents)
	{
		if (XenForo_Visitor::getInstance()->hasAdminPermission('manageDonations'))
			$contents .= $this->_template->create('robodn_donation_acp_icon', $this->_template->getParams());
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Donation');
	}

	protected function _getDonorModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Donor');
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Goal');
	}
}