<?php

class robodn_DonationManager_Model_Donor extends XenForo_Model
{
	const FETCH_USER = 0x01;

	public function getDonors(array $conditions = array(), array $fetchOptions = array())
	{
		$whereClause = $this->prepareDonorConditions($conditions);
		$orderClause = $this->prepareDonorOrderOptions($fetchOptions, 'donate.amount DESC');
		$joinOptions = $this->prepareDonorFetchOptions($fetchOptions);
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

		$donors = $this->_getDb()->fetchAll($this->limitQueryResults(
			'
				SELECT donor.*
					' . $joinOptions['selectFields'] . '
				FROM robodn_donor AS donor
					' . $joinOptions['joinTables'] . '
				WHERE ' . $whereClause . '
				' . $orderClause . '
			', $limitOptions['limit'], $limitOptions['offset'])
		);

		return $this->hideAnymousUsernames($donors);
	}

	public function prepareDonorConditions(array $conditions)
	{
		$db = $this->_getDb();
		$sqlConditions = array();

		return $this->getConditionsForClause($sqlConditions);
	}

	public function prepareDonorFetchOptions(array $fetchOptions)
	{
		$selectFields = '';
		$joinTables = '';

		if (isset($fetchOptions['join']))
		{
			if ($fetchOptions['join'] & self::FETCH_USER)
			{
				// Don't include guests in order by username
				$inner = false;
				if (!empty($fetchOptions['order']) && $fetchOptions['order'] == 'username')
					$inner = true;

				$selectFields .= ',
					user.*, IF (donor.anonymous, \'a\', user.username) AS username';

				$joinTables .= '
					' . ($inner ? 'INNER' : 'LEFT') . ' JOIN xf_user AS user ON (donor.user_id = user.user_id)';
			}
		}

		return array(
			'selectFields' => $selectFields,
			'joinTables'   => $joinTables
		);
	}

	public function prepareDonorOrderOptions(array &$fetchOptions, $defaultOrderSql = '')
	{
		$choices = array(
			'amount' => 'donor.amount',
			'username' => 'username',
			'last_donation_date' => 'donor.last_donation_date'
		);

		if (!empty($fetchOptions['order']) && $fetchOptions['order'] == 'username')
			$this->addFetchOptionJoin($fetchOptions, self::FETCH_USER);

		return $this->getOrderByClause($choices, $fetchOptions, $defaultOrderSql);
	}

	public function prepareDonor(array $donor)
	{
		if (key_exists('username', $donor))
		{
			if (empty($donor['username']))
				$donor['username'] = $donor['anonymous'] ? new XenForo_Phrase('robodn_anonymous') : new XenForo_Phrase('guest');
		}

		return $donor;
	}

	public function prepareDonors(array $donors)
	{
		foreach ($donors as &$donor)
			$donor = $this->prepareDonor($donor);

		return $donors;
	}

	public function hideAnymousUsernames($donations)
	{
		$phrase = new XenForo_Phrase('robodn_anonymous');
		foreach ($donations as &$donation)
		{
			if ($donation['anonymous'])
			{
				$donation['username'] = $phrase;
				$donation['user_id'] = 0;
			}
		}

		return $donations;
	}

	public function countDonors(array $conditions = array())
	{
		$fetchOptions = array();
		$whereClause = $this->prepareDonorConditions($conditions, $fetchOptions);

		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM robodn_donor
			WHERE ' . $whereClause
		);
	}

	public function getExtraDonationDataForUser(array $user)
	{
		$donations = $this->_getDb()->fetchAll('
			SELECT *
			FROM robodn_donor
			WHERE user_id = ?
		', $user['user_id']);

		$user['donated'] = 0;
		$user['last_donated_date'] = 0;
		foreach ($donations as $donation)
		{
			$user['donated'] += $donation['amount'];
			$user['last_donated_date'] = max($user['last_donated_date'], $donation['last_donation_date']);
		}

		$lastDonationDate = $this->_getDb()->fetchOne('
			SELECT donation_date
			FROM robodn_donation
			WHERE user_id = ?
			ORDER BY donation_date DESC
		', $user['user_id']);

		$user['last_donated_date'] = max($user['last_donated_date'], (int) $lastDonationDate);

		return $user;
	}

	public function getTopDonors($limit = 8)
	{
		$topDonors = $this->_getDb()->fetchAll($this->limitQueryResults(
			'
				SELECT donor.*, user.*
				FROM robodn_donor AS donor
					INNER JOIN xf_user AS user ON (donor.user_id = user.user_id)
				ORDER BY donor.amount DESC
			', $limit)
		);

		return $this->hideAnymousUsernames($topDonors);
	}
}