<?php

$startTime = microtime(true);
$fileDir = dirname(__FILE__);

require($fileDir . '/library/XenForo/Autoloader.php');
XenForo_Autoloader::getInstance()->setupAutoloader($fileDir . '/library');

XenForo_Application::initialize($fileDir . '/library', $fileDir);
XenForo_Application::set('page_start_time', $startTime);

$response = new Zend_Controller_Response_Http();
$request = new Zend_Controller_Request_Http();

$deps = new XenForo_Dependencies_Public();
$deps->preLoadData();

/*if ($request->getParam('log'))
{
	$logs = XenForo_Application::get('db')->fetchAll('SELECT * FROM merc_donation_log ORDER BY donation_log_id DESC');
	foreach ($logs as &$log)
		$log['transaction_details'] = unserialize($log['transaction_details']);

	Zend_Debug::dump($logs);
	exit;
}*/

try
{
	$transaction = new Merc_DonationManager_Transaction_PayPal($request);

	$output = $transaction->run();

	if ($transaction->hasErrors())
	{
		$errors = implode("<br />\n", $transaction->getErrors());
		$response->setBody(htmlspecialchars($errors));
		$response->setHttpResponseCode(400);
	}
	else
	{
		$response->setBody($output);
	}
}
catch (Exception $e)
{
	XenForo_Error::logException($e);

	$response->setHttpResponseCode(500);
	$response->setBody('Exception: ' . $e->getMessage());
}

$response->sendResponse();